#!/bin/bash
set -euo pipefail
url="${UPSTREAM_URL%%/}"

scheme="${url%%://*}"; rest="${url#*://}"
hostport="${rest%%/*}"                  # e.g. api.example.com:8443 OR api.example.com
host="${hostport%%:*}"
port="${hostport#*:}"
[ "$host" = "$port" ] && port="$([ "$scheme" = "https" ] && echo 443 || echo 80)"

# Normalize the path prefix
raw_path="${rest#*/}"
if [ "$raw_path" = "$rest" ]; then
  prefix="/"
else
  # ensure trailing slash
  prefix="/${raw_path%/}/"
fi

export UPSTREAM_SCHEME="$scheme"
export UPSTREAM_HOST="$host"
export UPSTREAM_PORT="$port"
export UPSTREAM_PREFIX="$prefix"

envsubst \
  '$DOMAIN \
   $CACHE_DISK_TTL \
   $CACHE_INDEX_SIZE \
   $CACHE_SIZE \
   $UPSTREAM_SCHEME \
   $UPSTREAM_HOST \
   $UPSTREAM_PORT \
   $UPSTREAM_PREFIX' \
  < /etc/nginx/templates/nginx.conf.template \
  > /etc/nginx/nginx.conf

exec nginx -g 'daemon off;'
