#!/bin/sh
echo "Setting up $DOMAIN using $CERTBOT_IMAGE"

CERTBOT_NAME=$(echo "$CERTBOT_IMAGE" | cut -d'/' -f2 | cut -d':' -f1)

if [ "$CERTBOT_NAME" = "dns-route53" ]; then
  # Plugin uses AWS_CONFIG_FILE instead of --dns-route53-credentials
  certbot certonly --$CERTBOT_NAME --email $CERTBOT_EMAIL --agree-tos --no-eff-email -d $DOMAIN
else
  certbot certonly --$CERTBOT_NAME --$CERTBOT_NAME-credentials /certbot.credentials \
    --email $CERTBOT_EMAIL --agree-tos --no-eff-email -d $DOMAIN
fi
