# Solsta Cache

## Description

Uses nginx to cache files. It is designed to be used in conjunction with the Solsta entitlement services. Because
the ip is designed to be internal we use a certbot DNS plugin to renew the certificate.

## Configure .env

Find `.env` in the project root and configure the following variables:

|Variable|Description|Example|
|-|-|-|
|CACHE_DIR|local directory to store cache|`/data/cache`|
|CACHE_DISK_TTL|time to store files on disk|`2d`|
|CACHE_INDEX_SIZE|shared memory to allocate for tracking cache items (keys + metadata)|`10m`|
|CACHE_SIZE|max used disk space in CACHE_DIR|`60g`|
|CERTBOT_EMAIL|email registered to dns name|`john.doe@example.com`|
|CERTBOT_IMAGE|Docker image supporting the certbot dns plugin|`certbot/dns-route53:latest`|
|DOMAIN|internal dns name|`internal.example.com`|
|UPSTREAM_URL|cdn url provided by Solid State Networks|`https://content.akamaized.net/ssn-path`|

## Configure certbot.credentials

Use the provided documentation at <https://eff-certbot.readthedocs.io/en/stable/using.html#dns-plugins> to setup
`certbot.credentials` in the project root according to the provided examples.

For example, if you are using the `certbot/dns-route53` image you need to create `certbot.credentials` with the
following content:

```ini
[default]
aws_access_key_id=AKIAIOSFODNN7EXAMPLE
aws_secret_access_key=wJalrXUtnFEMI/K7MDENG/bPxRfiCYEXAMPLEKEY
```

## Getting the certificate for the first time

Start the `docker-compose-setup.yaml` from the project root to get the certificate for the first time.

```shell
docker compose -f ./docker-compose-setup.yaml up
```

When the certificate is obtained you can stop the container by hitting `Ctrl+C`.

We don't need the setup container anymore, remove it with:

```shell
docker compose -f ./docker-compose-setup.yaml down
```

## Creating the cache server

On the initial setup we need to create the cache server containers. Run the following command to create and start the
containers in the background.

```shell
docker compose up -d
```

## Stopping the cache server

To stop the cache server run the following command from the project root:

```shell
docker compose stop
```

## Starting the cache server

To start the cache server after it's been created from the project root:

```shell
docker compose start
```

## Uninstalling the cache server

To uninstall the cache server run the following command from the project root:

```shell
docker compose down
```
